class SendMoneyModel {
  SendMoneyModel({
      String? remark, 
      String? status, 
      Data? data,}){
    _remark = remark;
    _status = status;
    _data = data;
}

  SendMoneyModel.fromJson(dynamic json) {
    _remark = json['remark'];
    _status = json['status'].toString();
    _data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }
  String? _remark;
  String? _status;
  Data? _data;

  String? get remark => _remark;
  String? get status => _status;
  Data? get data => _data;


}

class Data {
  Data({
      List<Recipients>? recipients, 
      List<Sources>? sources, 
      List<Purposes>? purposes, 
      dynamic sendingAmount, 
      dynamic recipientAmount, 
      String? sendingCountryId,
      dynamic recipientCountryId, 
      List<SendingCountries>? sendingCountries, 
      List<ReceivingCountries>? receivingCountries, 
      dynamic deliveryMethodId, 
      String? todaySendMoney, 
      String? thisMonthSendMoney,}){
    _recipients = recipients;
    _sources = sources;
    _purposes = purposes;
    _sendingAmount = sendingAmount;
    _recipientAmount = recipientAmount;
    _sendingCountryId = sendingCountryId;
    _recipientCountryId = recipientCountryId;
    _sendingCountries = sendingCountries;
    _receivingCountries = receivingCountries;
    _deliveryMethodId = deliveryMethodId;
    _todaySendMoney = todaySendMoney;
    _thisMonthSendMoney = thisMonthSendMoney;
}

  Data.fromJson(dynamic json) {
    if (json['recipients'] != null) {
      _recipients = [];
      json['recipients'].forEach((v) {
        _recipients?.add(Recipients.fromJson(v));
      });
    }
    if (json['sources'] != null) {
      _sources = [];
      json['sources'].forEach((v) {
        _sources?.add(Sources.fromJson(v));
      });
    }
    if (json['purposes'] != null) {
      _purposes = [];
      json['purposes'].forEach((v) {
        _purposes?.add(Purposes.fromJson(v));
      });
    }
    _sendingAmount = json['sending_amount'] != null ? json['sending_amount'].toString() : '';
    _recipientAmount = json['recipient_amount'] != null ? json['recipient_amount'].toString() : '';
    _sendingCountryId = json['sending_country_id'] != null ? json['sending_country_id'].toString() : '';
    _recipientCountryId = json['recipient_country_id'] != null ? json['recipient_country_id'].toString() : '';
    if (json['sending_countries'] != null) {
      _sendingCountries = [];
      json['sending_countries'].forEach((v) {
        _sendingCountries?.add(SendingCountries.fromJson(v));
      });
    }
    if (json['receiving_countries'] != null) {
      _receivingCountries = [];
      json['receiving_countries'].forEach((v) {
        _receivingCountries?.add(ReceivingCountries.fromJson(v));
      });
    }
    _deliveryMethodId = json['delivery_method_id'].toString();
    _todaySendMoney = json['today_send_money'] != null ? json['today_send_money'].toString():"";
    _thisMonthSendMoney = json['this_month_sendMoney']  != null ? json['this_month_sendMoney'].toString():"";
  }
  List<Recipients>? _recipients;
  List<Sources>? _sources;
  List<Purposes>? _purposes;
  dynamic _sendingAmount;
  dynamic _recipientAmount;
  String? _sendingCountryId;
  dynamic _recipientCountryId;
  List<SendingCountries>? _sendingCountries;
  List<ReceivingCountries>? _receivingCountries;
  dynamic _deliveryMethodId;
  String? _todaySendMoney;
  String? _thisMonthSendMoney;

  List<Recipients>? get recipients => _recipients;
  List<Sources>? get sources => _sources;
  List<Purposes>? get purposes => _purposes;
  dynamic get sendingAmount => _sendingAmount;
  dynamic get recipientAmount => _recipientAmount;
  String? get sendingCountryId => _sendingCountryId;
  dynamic get recipientCountryId => _recipientCountryId;
  List<SendingCountries>? get sendingCountries => _sendingCountries;
  List<ReceivingCountries>? get receivingCountries => _receivingCountries;
  dynamic get deliveryMethodId => _deliveryMethodId;
  String? get todaySendMoney => _todaySendMoney;
  String? get thisMonthSendMoney => _thisMonthSendMoney;


}

class ReceivingCountries {
  ReceivingCountries({
      int? id, 
      String? name, 
      String? countryCode, 
      String? dialCode, 
      String? currency, 
      String? rate, 
      String? image, 
      String? isSending, 
      String? isReceiving, 
      String? hasAgent, 
      String? status, 
      String? createdAt, 
      String? updatedAt, 
      List<CountryDeliveryMethods>? countryDeliveryMethods,}){
    _id = id;
    _name = name;
    _countryCode = countryCode;
    _dialCode = dialCode;
    _currency = currency;
    _rate = rate;
    _image = image;
    _isSending = isSending;
    _isReceiving = isReceiving;
    _hasAgent = hasAgent;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
    _countryDeliveryMethods = countryDeliveryMethods;
}

  ReceivingCountries.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'] ?? '';
    _countryCode = json['country_code'] != null ? json['country_code'].toString() : '';
    _dialCode = json['dial_code'] != null ? json['dial_code'].toString() : '';
    _currency = json['currency'] != null ? json['currency'].toString() : '';
    _rate = json['rate'] != null ? json['rate'].toString() : '';
    _image = json['image'].toString();
    _isSending = json['is_sending'].toString();
    _isReceiving = json['is_receiving'].toString();
    _hasAgent = json['has_agent'].toString();
    _status = json['status'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
    if (json['country_delivery_methods'] != null) {
      _countryDeliveryMethods = [];
      json['country_delivery_methods'].forEach((v) {
        _countryDeliveryMethods?.add(CountryDeliveryMethods.fromJson(v));
      });
    }
  }
  int? _id;
  String? _name;
  String? _countryCode;
  String? _dialCode;
  String? _currency;
  String? _rate;
  String? _image;
  String? _isSending;
  String? _isReceiving;
  String? _hasAgent;
  String? _status;
  String? _createdAt;
  String? _updatedAt;
  List<CountryDeliveryMethods>? _countryDeliveryMethods;

  int? get id => _id;
  String? get name => _name;
  String? get countryCode => _countryCode;
  String? get dialCode => _dialCode;
  String? get currency => _currency;
  String? get rate => _rate;
  String? get image => _image;
  String? get isSending => _isSending;
  String? get isReceiving => _isReceiving;
  String? get hasAgent => _hasAgent;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;
  List<CountryDeliveryMethods>? get countryDeliveryMethods => _countryDeliveryMethods;

}

class CountryDeliveryMethods {
  CountryDeliveryMethods({
      int? id, 
      String? countryId, 
      String? deliveryMethodId, 
      DeliveryMethod? deliveryMethod, 
      dynamic charge,}){
    _id = id;
    _countryId = countryId;
    _deliveryMethodId = deliveryMethodId;
    _deliveryMethod = deliveryMethod;
    _charge = charge;
}

  CountryDeliveryMethods.fromJson(dynamic json) {
    _id = json['id'];
    _countryId = json['country_id'].toString();
    _deliveryMethodId = json['delivery_method_id'].toString();
    _deliveryMethod = json['delivery_method'] != null ? DeliveryMethod.fromJson(json['delivery_method']) : null;
    _charge = json['charge'] != null ? json['charge'].toString() : '';
  }
  int? _id;
  String? _countryId;
  String? _deliveryMethodId;
  DeliveryMethod? _deliveryMethod;
  dynamic _charge;

  int? get id => _id;
  String? get countryId => _countryId;
  String? get deliveryMethodId => _deliveryMethodId;
  DeliveryMethod? get deliveryMethod => _deliveryMethod;
  dynamic get charge => _charge;

}

class DeliveryMethod {
  DeliveryMethod({
      int? id, 
      String? name,}){
    _id = id;
    _name = name;
}

  DeliveryMethod.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'] ?? '';
  }
  int? _id;
  String? _name;

  int? get id => _id;
  String? get name => _name;

}

class SendingCountries {
  SendingCountries({
      int? id, 
      String? name, 
      String? countryCode, 
      String? dialCode, 
      String? currency, 
      String? rate, 
      String? image, 
      String? isSending, 
      String? isReceiving, 
      String? hasAgent, 
      String? status, 
      String? createdAt, 
      String? updatedAt, 
      List<dynamic>? conversionRates,}){
    _id = id;
    _name = name;
    _countryCode = countryCode;
    _dialCode = dialCode;
    _currency = currency;
    _rate = rate;
    _image = image;
    _isSending = isSending;
    _isReceiving = isReceiving;
    _hasAgent = hasAgent;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
    _conversionRates = conversionRates;
}

  SendingCountries.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'] ?? '';
    _countryCode = json['country_code'] != null ? json['country_code'].toString() : '';
    _dialCode = json['dial_code'].toString();
    _currency = json['currency'] != null ? json['currency'].toString() : '';
    _rate = json['rate'] != null ? json['rate'].toString() : '';
    _image = json['image'].toString();
    _isSending = json['is_sending'].toString();
    _isReceiving = json['is_receiving'].toString();
    _hasAgent = json['has_agent'].toString();
    _status = json['status'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
    if (json['conversion_rates'] != null) {
      _conversionRates = [];
      json['conversion_rates'].forEach((v) {
        // _conversionRates?.add(Dynamic.fromJson(v));
      });
    }
  }
  int? _id;
  String? _name;
  String? _countryCode;
  String? _dialCode;
  String? _currency;
  String? _rate;
  String? _image;
  String? _isSending;
  String? _isReceiving;
  String? _hasAgent;
  String? _status;
  String? _createdAt;
  String? _updatedAt;
  List<dynamic>? _conversionRates;

  int? get id => _id;
  String? get name => _name;
  String? get countryCode => _countryCode;
  String? get dialCode => _dialCode;
  String? get currency => _currency;
  String? get rate => _rate;
  String? get image => _image;
  String? get isSending => _isSending;
  String? get isReceiving => _isReceiving;
  String? get hasAgent => _hasAgent;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;
  List<dynamic>? get conversionRates => _conversionRates;

}

class Purposes {
  Purposes({
      int? id, 
      String? name, 
      String? status, 
      String? createdAt, 
      String? updatedAt,}){
    _id = id;
    _name = name;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
}

  Purposes.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'] ?? '';
    _status = json['status'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
  }
  int? _id;
  String? _name;
  String? _status;
  String? _createdAt;
  String? _updatedAt;

  int? get id => _id;
  String? get name => _name;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;

}

class Sources {
  Sources({
      int? id, 
      String? name, 
      String? status, 
      String? createdAt, 
      String? updatedAt,}){
    _id = id;
    _name = name;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
}

  Sources.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'] ?? '';
    _status = json['status'].toString();
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
  }
  int? _id;
  String? _name;
  String? _status;
  String? _createdAt;
  String? _updatedAt;

  int? get id => _id;
  String? get name => _name;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;

}

class Recipients {
  Recipients({
      int? id, 
      String? userId, 
      String? name, 
      String? mobile, 
      String? email, 
      String? address, 
      String? createdAt, 
      String? updatedAt,}){
    _id = id;
    _userId = userId;
    _name = name;
    _mobile = mobile;
    _email = email;
    _address = address;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
}

  Recipients.fromJson(dynamic json) {
    _id = json['id'];
    _userId = json['user_id'].toString();
    _name = json['name'] ?? '';
    _mobile = json['mobile'] ?? '';
    _email = json['email'] ?? '';
    _address = json['address'] ?? '';
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
  }
  int? _id;
  String? _userId;
  String? _name;
  String? _mobile;
  String? _email;
  String? _address;
  String? _createdAt;
  String? _updatedAt;

  int? get id => _id;
  String? get userId => _userId;
  String? get name => _name;
  String? get mobile => _mobile;
  String? get email => _email;
  String? get address => _address;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;

}